#include <cstdio>
#include <vector>
#include <map>

#define maxn 201

using namespace std;

int n, c[maxn], v[maxn][maxn][maxn];
vector< int > dp[maxn][maxn];
int memo[maxn][maxn], next[maxn];

inline void add( int l, int r, int x, int y ) {
   v[l][r][x] = max( v[l][r][x], y );
}

int rek( int l, int r ) {
   if( dp[l][r].size() ) return memo[l][r];

   if( next[l] >= r ) {

      add( l, r, r-l, (r-l)*(r-l) );

   } else {
      vector< int >::iterator q, w;

      for( int i = next[l]; i < r; i = next[i] ) {
         
         int a = rek( l, i );
         int b = rek( i, r );

         if( c[i-1] != c[r-1] ) {
            
            add( l, r, b, v[l][i][a] + v[i][r][b] );
            
         } else {
            
            for( q = dp[l][i].begin(); q != dp[l][i].end(); ++q )
               for( w = dp[i][r].begin(); w != dp[i][r].end(); ++w )
                  add( l, r, *q+*w, v[l][i][*q] + v[i][r][*w] + 2 * (*q) * (*w) );
         }
      }

   }

   int ret = -1, last = -1;

   for( int i = r-l; i >= 0; --i ) {
      if( v[l][r][i] == -1 ) continue;

      if( ret == -1 || v[l][r][i] > v[l][r][ret] ) ret = i;

      if( last == -1 || last < v[l][r][i] ) {
         dp[l][r].push_back( i );
         last = v[l][r][i];
      }
   }

   return memo[l][r] = ret;
}

void init_next() {
   for( int i = 0; i < n; ++i )
      for( next[i] = i; next[i] < n && c[ next[i] ] == c[ i ]; ++next[i] );
}

void load() {
   scanf( "%d", &n );
   for( int i = 0; i < n; ++i ) scanf( "%d", &c[i] );
   for( int i = 0; i <= n; ++i )
      for( int j = i; j <= n; ++j ) {
         dp[i][j].clear();
         memset( v[i][j], -1, (n+1) * (sizeof(int)) );
      }
}

int main(void) {
   int tt = 1;
   //   scanf( "%d", &tt );
   for( int i = 1; i <= tt; ++i ) {
      load();
      init_next();
      printf( "%d\n", v[0][n][ rek( 0, n ) ] );
   }
   return 0;
}
